/*----------------------------------------------------------------------------*/
/* Copyright (C) 2002, 2003, 2004 Freescale, Inc.  All Rights Reserved.
 *
 * Freescale makes no warranty, representation or guarantee regarding
 * the suitability of its product, and specifically disclaims any and all
 * liability, including without limitation consequential or incidental
 * damages.
 *----------------------------------------------------------------------------*/

#include "z650Exceptions.h"    /* IVPR and default exception handlers setup */
#include "z650INTCInterrupts.h" /* INTC Interrupts Requests configuration */

#pragma section code_type ".init"

#undef INIT_EXTERNAL_BUS_INTERFACE

#ifdef __cplusplus
extern "C" {
#endif

extern __asm void __start();
__asm void __reset(void);
__asm void usr_init();
/*lint -esym(752,__start,__initMMUExternalMemory,__initExtBusInterface,__initExtBusInterface,__initInterrupts) */			  
#if defined(INIT_EXTERNAL_BUS_INTERFACE)
extern void __initMMUExternalMemory(void);  /* set-up MMU for EXTMEM0 access */
extern void __initExtBusInterface(void);    /* set up the External Bus Interface */
#endif

#ifdef __cplusplus
}
#endif


__asm void __reset(void)
{
  b   __start
}

__asm void usr_init()
{
  nofralloc

    mflr     r31                         /* save off return address in NV reg */

#if defined(INIT_EXTERNAL_BUS_INTERFACE)
    bl      __initMMUExternalMemory      /* set up access to external memory */
    bl      __initExtBusInterface        /* set up the External Bus Interface */
#endif

#if !NO_INTERRUPTS 
    bl      __initExceptionHandlers
    bl      __initINTCInterrupts         /* Set up INTC Interrupts Requests handling */
#endif

    mtlr    r31                          /* get saved return address */
    
    blr
}
